
* ======================    THIS DO FILE   ===========================================
** Merges the annual employment data and the relevant annual Compustat files to
*    quarterly data
* ===========================================================================================
*
set more off
pause off
clear
macro drop _all
set seed 1073741823

graph set window fontface "Times New Roman"
cd ""
 
global mainpath "/Users/ekurt/Desktop/MP ASYM/Stata"

cap log close
log using "${mainpath}/Log/DataPrep/3.Annual data merge.log", replace

use "${mainpath}/Raw_data/Annual/Comp_YRaw.dta", clear

keep if fic =="USA"
encode gvkey, gen(gvkeyn)

gen cyear = year(datadate)

* Compustat month of reporting
gen cquarter = 1 if inrange(fyrc,1,3)
replace cquarter = 2 if inrange(fyrc,4,6)
replace cquarter = 3 if inrange(fyrc,7,9)
replace cquarter = 4 if inrange(fyrc,10,12)

sort gvkeyn cyear

rename emp empYComp

keep gvkey cyear empYComp fyrc datadate

sort gvkey cyear datadate

* duplicate observations 
cap drop a
bysort gvkey: gen     a =1 if cyear == cyear[_n+1]
bysort gvkey: replace a =2 if cyear == cyear[_n-1]
drop if a == 1

sort gvkey cyear datadate

cap drop b
bysort gvkey: gen b =1 if cyear == cyear[_n+1]
drop if b ==1

isid gvkey cyear

tempfile Comp_annual
save `Comp_annual'

use "${mainpath}/Data/CompQuarterlyData.dta", clear

sort gvkeyn qdate
merge m:1 gvkey cyear using `Comp_annual'

count if _merge ==2 & qdate ==.

sort gvkeyn cyear cquarter

drop if cyear < 1965

cap drop summerge
bysort gvkey: egen summerge = mean(_merge)

drop if summerge ==2 // firms with only annual observations
drop if _merge ==2 

sort gvkeyn cyear cquarter

sum empYComp, det

save "${mainpath}/Data/Quarter_LP_Ready3.dta",replace

cap log close
